#
# Copyright (C) 2015-2018 Night Dive Studios, LLC.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#   File:       2D.make
#   Target:     2D.xcoff  (static library)


MAKEFILE     = 2D.make
MondoBuild = ""
SymPPC      = -sym off 
ObjDirPPC   = :Obj:
Source		 = :Source:
Clip		 = :Source:Clip:
Flat8		 = :Source:Flat 8:
Gen			 = :Source:Gen:
GR			 = :Source:GR:
RSD			 = :Source:RSD:
FixDir	 	 = ::FIX:Source:
ResDir		 = ::RES:Source:
LGDir		 = ::LG:Source:
DStructDir	 = ::DSTRUCT:Source:
LIB			 = :::MrC LIB:
Includes     = -i :Source: 
			   -i {Clip} 
			   -i "{Flat8}" 
			   -i {Gen} 
			   -i {GR} 
			   -i {RSD} 
			   -i ::H: 
			   -i ":::Mac Src:" 
			   -i {FixDir} 
			   -i {DStructDir} 
			   -i {ResDir} 
			   -i {LGDir}

PPCCOptions  = {Includes} {SymPPC} -align mac68k -inline on -opt speed -load "{LIB}MacHeaders.MrC"

.o  .C {MondoBuild}
	MrCPP {depDir}{Default}.C -o {Targ} {PPCCOptions}

ObjectsPPC  = 
		{ObjDirPPC}BIT.o 
		{ObjDirPPC}BITMAP.o 
		{ObjDirPPC}BLEND.o 
		{ObjDirPPC}BUFFER.o 
		{ObjDirPPC}CANVAS.o 
		{ObjDirPPC}CHAIN.o 
		{ObjDirPPC}ChnFuncs.o 
		{ObjDirPPC}CHRSIZ.o 
		{ObjDirPPC}CHRWID.o 
		{ObjDirPPC}CLOSE.o 
		{ObjDirPPC}CONTEXT.o 
		{ObjDirPPC}CNVTAB.o 
		{ObjDirPPC}DETECT.o 
		{ObjDirPPC}FCNTAB.o 
		{ObjDirPPC}INIT.o 
		{ObjDirPPC}INVTAB.o 
		{ObjDirPPC}LINTAB.o 
		{ObjDirPPC}MODE.o 
		{ObjDirPPC}PAL.o 
		{ObjDirPPC}PERMAP.o 
		{ObjDirPPC}PERSETUP.o 
		{ObjDirPPC}PERTOL.o 
		{ObjDirPPC}PIXFILL.o 
		{ObjDirPPC}RGB.o 
		{ObjDirPPC}SCREEN.o 
		{ObjDirPPC}SSCRN.o 
		{ObjDirPPC}StateStk.o 
		{ObjDirPPC}STRSCL.o 
		{ObjDirPPC}STRUSCL.o 
		{ObjDirPPC}STRNSIZ.o 
		{ObjDirPPC}STRSIZ.o 
		{ObjDirPPC}STRWID.o 
		{ObjDirPPC}STRWRAP.o 
		{ObjDirPPC}TEMPBM.o 
		{ObjDirPPC}TEMPTM.o 
		{ObjDirPPC}TLUCDAT.o 
		{ObjDirPPC}TLUCTAB.o 
		{ObjDirPPC}VALLOC.o 
		{ObjDirPPC}VTAB.o 
		{ObjDirPPC}WIRPOLY.o 
		
		{ObjDirPPC}FL8BL.o 
		{ObjDirPPC}FL8BLDBL.o 
		{ObjDirPPC}FL8CHFL8.o 
		{ObjDirPPC}FL8CLEAR.o 
		{ObjDirPPC}FL8CLIN.o 
		{ObjDirPPC}FL8CNV.o 
		{ObjDirPPC}FL8CPLY.o 
		{ObjDirPPC}FL8DBL.o 
		{ObjDirPPC}FL8FL8.o 
		{ObjDirPPC}FL8FL8C.o 
		{ObjDirPPC}FL8FL8M.o 
		{ObjDirPPC}FL8FLTR2.o 
		{ObjDirPPC}FL8FT.o 
		{ObjDirPPC}FL8G24.o 
		{ObjDirPPC}FL8GFL8.o 
		{ObjDirPPC}FL8GPIX.o 
		{ObjDirPPC}FL8HFL8.o 
		{ObjDirPPC}FL8HLIN.o 
		{ObjDirPPC}FL8LIN.o 
		{ObjDirPPC}FL8LP.o 
		{ObjDirPPC}FL8MSCL.o 
		{ObjDirPPC}FL8MONO.o 
		{ObjDirPPC}FL8NS.o 
		{ObjDirPPC}FL8NTRP2.o 
		{ObjDirPPC}FL8P.o 
		{ObjDirPPC}FL8P24.o 
		{ObjDirPPC}FL8PIX.o 
		{ObjDirPPC}FL8PLY.o 
		{ObjDirPPC}FL8PNT.o 
		{ObjDirPPC}FL8RECT.o 
		{ObjDirPPC}FL8ROW.o 
		{ObjDirPPC}FL8RSD8.o 
		{ObjDirPPC}FL8S.o 
		{ObjDirPPC}FL8SLIN.o 
		{ObjDirPPC}FL8SPLY.o 
		{ObjDirPPC}FL8SUB.o 
		{ObjDirPPC}FL8TL8.o 
		{ObjDirPPC}FL8VLIN.o 
		{ObjDirPPC}FL8WCLIN.o 
		{ObjDirPPC}FL8WLIN.o 
		
		{ObjDirPPC}FL8LNOP.o 
		{ObjDirPPC}FL8LL.o 
		{ObjDirPPC}FL8NL.o 
		{ObjDirPPC}Fl8F.o 
		{ObjDirPPC}FL8LF.o 
		
		{ObjDirPPC}FL8W.o 
		{ObjDirPPC}FL8LW.o 
		
		{ObjDirPPC}FL8TSMAP.o 
		{ObjDirPPC}FL8COP.o 
		{ObjDirPPC}FL8CTP.o 
		{ObjDirPPC}FL8LOP.o 
		{ObjDirPPC}FL8LTP.o 
		{ObjDirPPC}FL8OPL.o 
		{ObjDirPPC}FL8TPL.o 
		
		{ObjDirPPC}GENBOX.o 
		{ObjDirPPC}GENCHFL8.o 
		{ObjDirPPC}GENCHR.o 
		{ObjDirPPC}GENCIRC.o 
		{ObjDirPPC}GENCLIN.o 
		{ObjDirPPC}GENCNV.o 
		{ObjDirPPC}GENCWLIN.o 
		{ObjDirPPC}GENDISK.o 
		{ObjDirPPC}GENEL.o 
		{ObjDirPPC}GENERAL.o 
		{ObjDirPPC}GENF24.o 
		{ObjDirPPC}GENFL8.o 
		{ObjDirPPC}GENFL8C.o 
		{ObjDirPPC}GENGFL8.o 
		{ObjDirPPC}GENHFL8.o 
		{ObjDirPPC}GENHLIN.o 
		{ObjDirPPC}GENLIN.o 
		{ObjDirPPC}GENMONO.o 
		{ObjDirPPC}GENOV.o 
		{ObjDirPPC}GENPIX.o 
		{ObjDirPPC}GENRECT.o 
		{ObjDirPPC}GENRSD8.o 
		{ObjDirPPC}GENRSDBM.o 
		{ObjDirPPC}GENRSDTM.o 
		{ObjDirPPC}GENSLIN.o 
		{ObjDirPPC}GENSTR.o 
		{ObjDirPPC}GENTE.o 
		{ObjDirPPC}GENTL8.o 
		{ObjDirPPC}GENTM.o 
		{ObjDirPPC}GENUCHR.o 
		{ObjDirPPC}GENUCLIN.o 
		{ObjDirPPC}GENUHLIN.o 
		{ObjDirPPC}GENULIN.o 
		{ObjDirPPC}GENUSLIN.o 
		{ObjDirPPC}GENUSTR.o 
		{ObjDirPPC}GENUVLIN.o 
		{ObjDirPPC}GENVCPLY.o 
		{ObjDirPPC}GENVLIN.o 
		{ObjDirPPC}GENVPOLY.o 
		{ObjDirPPC}GENVRECT.o 
		{ObjDirPPC}GENWCLIN.o 
		{ObjDirPPC}GENWLIN.o 
		
		{ObjDirPPC}GRD.o 
		{ObjDirPPC}GRILIN.o 
		{ObjDirPPC}GRMALLOC.o 
		{ObjDirPPC}GRNULL.o 
		{ObjDirPPC}GRUILIN.o 
		
		{ObjDirPPC}devtab.o 
		{ObjDirPPC}MacDev.o 
		{ObjDirPPC}SVGAINIT.o 
		
		{ObjDirPPC}RSDCVT.o 
		{ObjDirPPC}RSDUnpack.o 
		
		{ObjDirPPC}CLPCLIN.o 
		{ObjDirPPC}CLPF24.o 
		{ObjDirPPC}CLPLIN.o 
		{ObjDirPPC}CLPLIN2.o 
		{ObjDirPPC}CLPLTAB.o 
		{ObjDirPPC}CLPMONO.o 
		{ObjDirPPC}CLPPLY.o 
		{ObjDirPPC}CLPPOLY.o 
		{ObjDirPPC}CLPRECT.o 
		{ObjDirPPC}CLPSLIN.o 

2DObjectsAsm  = 
		{Source}LinearLoop.s.o 
		{Source}FloorLoop.s.o 
		{Source}WallLitLoop1D.s.o 
		{Source}PermapLoop.s.o

:Obj:  :Source:		# Objects in Obj folder depend on sources in Source folder
:Obj:  {Clip}
:Obj:  "{Flat8}"
:Obj:  {Gen}
:Obj:  {GR}
:Obj:  {RSD}

2D  {MondoBuild} {ObjectsPPC} {2DObjectsAsm}
	PPCLink 
		-o "{LIB}"{Targ}.xcoff {SymPPC} 
		{ObjectsPPC} 
		{2DObjectsAsm} 
		-t 'XCOF' 
		-c 'MPS ' 
		-xm l 
		-mf
