#
# Copyright (C) 2015-2018 Night Dive Studios, LLC.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#   File:       2dTest.make
#   Target:     2dTest  (app)


MAKEFILE     = 2dTest.make
MondoBuild = {MAKEFILE}
SymPPC      = -sym off 
ObjDirPPC   = :Obj:
Source		 = :Source:
FixDir	 	 = ::FIX:Source:
ResDir		 = ::RES:Source:
LGDir		 = ::LG:Source:
DStructDir	 = ::DSTRUCT:Source:
LIB			 = :::MrC LIB:
Includes     = -i :Source: 
			   -i ::H: 
			   -i ":::Mac Src:" 
			   -i {FixDir} 
			   -i {DStructDir} 
			   -i {ResDir} 
			   -i {LGDir}


PPCCOptions  = {Includes} {SymPPC} -align mac68k -inline on -opt speed -load "{LIB}MacHeaders.MrC"

.o  .C {MondoBuild}
	MrCPP {depDir}{Default}.C -o {Targ} {PPCCOptions}

ObjectsPPC  = 
		{ObjDirPPC}2dTest.o 
		{ObjDirPPC}TestInitMac.o 
		{ObjDirPPC}ShockBitmap.o 

:Obj:  :
:Obj:  :Source:
:Obj:  ":::Mac Src:"

2dTest  {MondoBuild} {ObjectsPPC}
	PPCLink 
		-o {Targ} {SymPPC} 
		{ObjectsPPC} 
		-t 'APPL' 
		-c '????' 
		"{LIB}"FIX.xcoff 
		"{LIB}"2D.xcoff 
		"{LIB}"LG.xcoff 
#		"{PPCLibraries}"PPCSIOW.o 
		"{SharedLibraries}"InterfaceLib 
		"{SharedLibraries}"StdCLib 
#		"{PPCLibraries}"InterfaceLib.xcoff 
#		"{PPCLibraries}"StdCLib.xcoff 
		"{PPCLibraries}"MathLib.xcoff 
		"{PPCLibraries}"StdCRuntime.o 
		"{PPCLibraries}"MrCPlusLib.o 
#		"{PPCLibraries}"MrCIOStreams.o 
		"{PPCLibraries}"PPCCRuntime.o 
		-librename MathLib.xcoff=MathLib


2dTest  {MondoBuild} 2dTest..rsrc
	Rez -a 2dTest..rsrc -o {Targ}
