#
# Copyright (C) 2015-2018 Night Dive Studios, LLC.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#   File:       3D.make
#   Target:     3D.xcoff  (static library)


MAKEFILE     = 3D.make
MondoBuild = ""
SymPPC      = -sym off 
ObjDirPPC   = :Obj:
Source		 = :Source:
Clip		 = :Source:Clip:
Flat8		 = :Source:Flat 8:
Gen			 = :Source:Gen:
GR			 = :Source:GR:
RSD			 = :Source:RSD:
FixDir	 	 = ::FIX:Source:
ResDir		 = ::RES:Source:
2dDir		 = ::2D:Source:
LGDir		 = ::LG:Source:
DStructDir	 = ::DSTRUCT:Source:
LIB			 = :::MrC LIB:
Includes     = -i :Source: 
			   -i ::H: 
			   -i ":::Mac Src:" 
			   -i {FixDir} 
			   -i {DStructDir} 
			   -i {ResDir} 
			   -i {2dDir} 
			   -i {LGDir}

PPCCOptions  = {Includes} {SymPPC} -align mac68k -inline on -opt speed -load "{LIB}MacHeaders.MrC"

.o  .C {MondoBuild}
	MrCPP {depDir}{Default}.C -o {Targ} {PPCCOptions}

ObjectsPPC  = 
		{ObjDirPPC}ALLOC.o 
		{ObjDirPPC}Bitmap.o 
		{ObjDirPPC}CLIP.o 
		{ObjDirPPC}DETAIL.o 
		{ObjDirPPC}FOV.o 
		{ObjDirPPC}GlobalV.o 
		{ObjDirPPC}INSTANCE.o 
		{ObjDirPPC}INTERP.o 
		{ObjDirPPC}LIGHT.o 
		{ObjDirPPC}MATRIX.o 
		{ObjDirPPC}POINTS.o 
		{ObjDirPPC}POLYGON.o 
		{ObjDirPPC}SLEW.o 
		{ObjDirPPC}TMAP.o 
		{ObjDirPPC}VECTOR.o

:Obj:  :Source:		# Objects in Obj folder depend on sources in Source folder

3D  {MondoBuild} {ObjectsPPC}
	PPCLink 
		-o "{LIB}"{Targ}.xcoff {SymPPC} 
		{ObjectsPPC} 
		-t 'XCOF' 
		-c 'MPS ' 
		-xm l 
		-mf
