#
# Copyright (C) 2015-2018 Night Dive Studios, LLC.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#   File:       3dTest.make
#   Target:     3dTest  (app)


MAKEFILE     = 3dTest.make
MondoBuild = {MAKEFILE}
SymPPC      = -sym off 
ObjDirPPC   = :Obj:
Source		 = :Source:
FixDir	 	 = ::FIX:Source:
LGDir		 = ::LG:Source:
ResDir		 = ::RES:Source:
2dDir		 = ::2D:Source:
3dDir		 = ::3D:Source:
DStructDir	 = ::DSTRUCT:Source:
LIB			 = :::MrC LIB:
Includes     = -i :Source: 
			   -i ::H: 
			   -i ":::Mac Src:" 
			   -i {FixDir} 
			   -i {ResDir} 
			   -i {DStructDir} 
			   -i {2dDir} 
			   -i {3dDir} 
			   -i {LGDir}


PPCCOptions  = {Includes} {SymPPC} -align mac68k -inline on -opt speed -load "{LIB}MacHeaders.MrC"

.o  .C {MondoBuild}
	MrCPP {depDir}{Default}.C -o {Targ} {PPCCOptions}

ObjectsPPC  = 
		{ObjDirPPC}3dTest.o 
		{ObjDirPPC}GenBoxTest.o 
		{ObjDirPPC}TestInitMac.o 
		{ObjDirPPC}ShockBitmap.o 

:Obj:  :Source:
:Obj:  :Tests:
:Obj:  ":::Mac Src:"
 
3dTest  {MondoBuild} {ObjectsPPC} "{LIB}"3D.xcoff
	PPCLink 
		-o {Targ} {SymPPC} 
		-main __cplusstart 
		{ObjectsPPC} 
		-t 'APPL' 
		-c '????' 
		"{LIB}"FIX.xcoff 
		"{LIB}"3D.xcoff 
		"{LIB}"2D.xcoff 
		"{LIB}"LG.xcoff 
		"{SharedLibraries}"InterfaceLib 
		"{SharedLibraries}"StdCLib 
		"{PPCLibraries}"MathLib.xcoff 
		"{PPCLibraries}"StdCRuntime.o 
		"{PPCLibraries}"MrCPlusLib.o 
#		"{PPCLibraries}"MrCIOStreams.o 
		"{PPCLibraries}"PPCCRuntime.o 
		-librename MathLib.xcoff=MathLib
