/*

Copyright (C) 2015-2018 Night Dive Studios, LLC.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
*/
#pragma cplusplus off

#include <stdio.h>
#include <stdlib.h>
#include "EDMS.h"

Marble marble;
State state;
EDMS_data emetic;
physics_handle silly;


//------------------
// Prototypes
//------------------
void	testback( physics_handle C, physics_handle V, int bad, long DATA1, long DATA2, fix location[3] );
void	off_playfield( physics_handle ph );


//------------------------------------------------------------
//	Here is a test collision callback...
//------------------------------------------------------------
void main(void)
{
	physics_handle m1, m2, m3;
	short		i;
	
	//	Set the EDMS startup parameters and startup...
	emetic.playfield_size = fix_make(100,0);
	emetic.min_physics_handle = 0;
	emetic.collision_callback = testback;
	emetic.wall_callback = NULL;
	emetic.awol_callback = off_playfield;
	emetic.snooz_callback = off_playfield;

	EDMS_startup( &emetic );
	
	marble.mass = fix_make(1,0);		// 1
	marble.size = fix_make(0,0x8000);	// 0.5
	marble.pep  = fix_make(8,0);		// 1

	state.X = fix_make(15,0);	state.X_dot = fix_make(1,0x1000);
	state.Y = fix_make(12,0);	state.Y_dot = fix_make(5,0x1000);
	state.Z = fix_make(10,0);	state.Z_dot = 0;

	silly = EDMS_make_marble( &marble, &state );
	EDMS_settle_object( silly );

	state.X = fix_make(16,0);
	m1 = EDMS_make_marble( &marble, &state );
	state.X = fix_make(14,0);
	m2 = EDMS_make_marble( &marble, &state );
	state.X = fix_make(13,0);
	m3 = EDMS_make_marble( &marble, &state );
	
	EDMS_sanity_check();
	EDMS_inventory_and_statistics( TRUE );
	
	// Loop to do some stuff
	
	for (i = 0; i < 1000; i++)
	{
		EDMS_soliton_lite ( fix_make(0,0x0200) );
		
		if (i % 200 == 0)
			EDMS_control_marble( silly, fix_make(15, 0x0000), fix_make(2, 0x8000), fix_make( 1, 0 ) );

		if (i == 700)
			EDMS_kill_object( m2 );
	}
	
	EDMS_sanity_check();
	EDMS_inventory_and_statistics( TRUE );
	
}

//------------------------------------------------------------
//	Here is a test collision callback...
//------------------------------------------------------------
void	testback( physics_handle C, physics_handle V, int bad, long DATA1, long DATA2, fix location[3] )
{									  	
	printf( "Callback: %i hits %i with badness %i.\n", C, V, bad );
}

//------------------------------------------------------------
//	And here is the off playfield callback...
//------------------------------------------------------------
void	off_playfield( physics_handle ph )
{
	printf( "Hey, physics_handle %i is off the playfield!\n", ph );
}



//	Here are some fake functions which should be dealt with!!!...
//	=============================================================

//	To be replaced with the terrain functions of your choice...
//	==========================================================
//	Regular guy terrain...
//	----------------------
fix Terrain( fix X, fix Y, int deriv )
{	
	return 0;
}

// FF terrain...
// -------------
void  FF_terrain( fix X, fix Y, fix Z, terrain_ff* TFF ) {

   X += Y*Z;

}

//	Indoor terrain vis a vis Citadel...
//	-----------------------------------
void	Indoor_Terrain( fix X, fix Y, fix Z, fix R ) {

	X = Y*Z + R;
}

//	And here, ladies and gentlemen, is a celebration of C and C++ and their
//	untamed passion...
//	==================
TerrainData	terrain_info;
